package com.example.sefinsa_app.ui.reporteDiario;

import androidx.annotation.RequiresApi;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.GastosController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.ReporteDiarioDeRutasController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Gastos;
import com.example.sefinsa_app.models.ReporteDiario;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteDiarioAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class ReporteDiarioFragment extends Fragment {

    private ReporteDiarioViewModel mViewModel;
    private SharedPreferences sesion;

    private ArrayList<ReporteDiario> reporteDiarios, reporteDiariosFiltrado, reportesFiltradosNombres, reportesAgregados;

    private TextInputLayout tlFecha, tlRuta, tlNombre;

    private Button btnGastos, btnGuardar, btnTotales, btnAgregar;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private GastosController gastosController;
    private ReporteDiarioDeRutasController reportediarioderutasController;
    private RutaController rutaController;

    private String ruta_id = "", gastos_id = "";
    private int previousLength;
    private boolean backSpace;

    private static ProgressDialog dialog;

    private RecyclerView recyclerView;
    private ReporteDiarioAdapter reporteDiarioAdapter;
    private LinearLayoutManager linearLayoutManager;

    private AutoCompleteTextView rutasAutoCompleteTextView;

    private Gastos gastos;

    private boolean buscarReporte = false;

    private TextInputEditText svPoblaciones;

    //ArrayList<Poblacion> poblaciones;

    ArrayList<ReporteDiario> poblacionesReporte;
    ArrayAdapter<ReporteDiario> poblacionesAdapter;

    String poblacion_id = "", poblacion_nombre = "", estimado_poblacion = "", gasto_id="";

    private PoblacionController poblacionController;

    public static ReporteDiarioFragment newInstance() {
        return new ReporteDiarioFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        requireActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
        return inflater.inflate(R.layout.fragment_reporte_diario, container, false);
    }
    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        rutasAutoCompleteTextView.setText("", false);
        if(svPoblaciones != null)
            svPoblaciones.setText("");
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                Log.d("ReporteDiarioFragment", "Refresh seleccionado...................");

                // Luego llama a getNuevoReporteDiarioRutasOnline()
                getNuevoReporteDiarioRutasOnline();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void getNuevoReporteDiarioRutasOnlineUpd() {
        dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();
        Log.d("DEBUG", "Entro en actualizar registros al INICIO...........");
        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteDiarioRutasAPP");
            data.put("empleado_id", sesion.getString("id", ""));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                JSONArray reportesArray = response.getJSONArray("data");

                                // Preparar arrays separados
                                JSONArray reporteArray = new JSONArray();
                                JSONArray gastosArray = new JSONArray();

                                // Separar datos de reportes y gastos
                                for (int i = 0; i < reportesArray.length(); i++) {
                                    JSONObject reporteCompleto = reportesArray.getJSONObject(i);

                                    // Extraer datos de reporte
                                    JSONObject reporte = new JSONObject();
                                    reporte.put("id", reporteCompleto.getString("id"));
                                    reporte.put("poblacion_id", reporteCompleto.getString("poblacion_id"));
                                    reporte.put("estimacion", reporteCompleto.getString("estimacion"));
                                    reporte.put("abonos_semana", reporteCompleto.getString("abonos_semana"));
                                    reporte.put("recuperacion_semana", reporteCompleto.getString("recuperacion_semana"));
                                    reporte.put("recuperacion_vencida", reporteCompleto.getString("recuperacion_vencida"));
                                    reporte.put("anticipos", reporteCompleto.getString("anticipos"));
                                    reporte.put("total_1", reporteCompleto.getString("total_1"));
                                    reporte.put("recuperacion_prestamos", reporteCompleto.getString("recuperacion_prestamos"));
                                    reporte.put("colocacion", reporteCompleto.getString("colocacion"));
                                    reporte.put("prestamo_colocadora", reporteCompleto.getString("prestamo_colocadora"));
                                    reporte.put("comision", reporteCompleto.getString("comision"));
                                    reporte.put("bono_colocadora", reporteCompleto.getString("bono_colocadora"));
                                    reporte.put("total_2", reporteCompleto.getString("total_2"));
                                    reporte.put("saldo", reporteCompleto.getString("saldo"));
                                    reporte.put("pendiente_recuperar", reporteCompleto.getString("pendiente_recuperar"));
                                    reporte.put("abonos_recuperar", reporteCompleto.getString("abonos_recuperar"));
                                    reporte.put("comentario", reporteCompleto.getString("comentario"));
                                    reporte.put("empleado_id", reporteCompleto.getString("empleado_id"));
                                    reporte.put("gastos_id", reporteCompleto.getString("gastos_id"));
                                    reporte.put("fecha", reporteCompleto.getString("fecha"));
                                    reporte.put("fecha_registro", reporteCompleto.getString("fecha_registro"));
                                    reporteArray.put(reporte);

                                    // Extraer datos de gastos
                                    JSONObject gasto = new JSONObject();
                                    gasto.put("id", reporteCompleto.getString("gastos_id"));
                                    gasto.put("otros", reporteCompleto.optString("otros", "0"));
                                    gasto.put("gasolina", reporteCompleto.optString("gasolina", "0"));
                                    gasto.put("hotel", reporteCompleto.optString("hotel", "0"));
                                    gasto.put("alimentos", reporteCompleto.optString("alimentos", "0"));
                                    gasto.put("casetas", reporteCompleto.optString("casetas", "0"));
                                    gasto.put("total", reporteCompleto.optString("total_gastos", "0"));
                                    gastosArray.put(gasto);
                                }

                                // Insertar datos en SQLite
                                updateDatosEnSQLite(reporteArray, gastosArray);

                                dialog.dismiss();
                                Toast.makeText(getActivity(), "Datos sincronizados correctamente", Toast.LENGTH_SHORT).show();
                            } else {
                                dialog.dismiss();
                                Toast.makeText(getActivity(), "No se encontraron datos para sincronizar", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            dialog.dismiss();
                            e.printStackTrace();
                            Toast.makeText(getActivity(), "Error al procesar datos del servidor", Toast.LENGTH_SHORT).show();
                        }
                    }

                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    // Método para comparar dos fechas (servidor vs local)
    private boolean isFechaMasReciente(String fechaServidor, String fechaLocal) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // Ajusta el formato según el formato de tus fechas
            Date fechaServidorDate = dateFormat.parse(fechaServidor);
            Date fechaLocalDate = dateFormat.parse(fechaLocal);

            return Objects.requireNonNull(fechaServidorDate).after(fechaLocalDate); // Retorna true si la fecha del servidor es más reciente
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return false; // Si no se puede comparar, devuelve false por defecto
    }
    // Método para obtener la fecha de registro desde SQLite
    private void updateDatosEnSQLite(JSONArray reporteArray, JSONArray gastosArray) {
        SQLiteDatabase db = new DatabaseHelper(getActivity()).getWritableDatabase();

        try {
            // Iterar a través de los reportes
            for (int i = 0; i < reporteArray.length(); i++) {
                JSONObject reporte = reporteArray.getJSONObject(i);

                String id = reporte.getString("id");
                String fecha_registro_servidor = reporte.getString("fecha_registro");

                // Obtener la fecha de registro de la base de datos SQLite
                String fecha_registro_local = getFechaRegistroSQLite(db, id);

                // Verifica si el registro debe insertarse o actualizarse
                if (fecha_registro_local == null || fecha_registro_local.isEmpty()) {
                    // Si no existe el registro en SQLite, haz un INSERT
                    ContentValues values = new ContentValues();
                    insertAllFields(values, reporte);
                    values.put("fecha_registro", fecha_registro_servidor);

                    // Realiza el insert en la base de datos
                    long newRowId = db.insert("reporte_diario_rutas", null, values);
                    Log.d("DEBUG", "Se insertó un nuevo registro con ID " + id + ": " + newRowId);
                } else if (isFechaMasReciente(fecha_registro_servidor, fecha_registro_local)) {
                    // Si la fecha del servidor es más reciente, hacer el UPDATE
                    ContentValues values = new ContentValues();

                    // Actualizar todos los campos con los valores del servidor
                    insertAllFields(values, reporte);
                    values.put("fecha_registro", fecha_registro_servidor);

                    // Actualizar los datos en SQLite
                    int rowsAffected = db.update("reporte_diario_rutas", values, "id = ?", new String[]{id});
                    Log.d("DEBUG", "Número de filas actualizadas para ID " + id + ": " + rowsAffected);
                } else {
                    Log.d("DEBUG", "La fecha del servidor no es más reciente para el reporte ID " + id);
                }
            }

            // Iterar a través de los gastos y hacer solo INSERT si no existe
            for (int i = 0; i < gastosArray.length(); i++) {
                JSONObject gasto = gastosArray.getJSONObject(i);

                String id = gasto.getString("id");

                // Verificar si el gasto ya existe en la tabla
                if (!existeGastoEnSQLite(db, id)) {
                    ContentValues values = new ContentValues();
                    values.put("id", id);
                    values.put("otros", gasto.getString("otros"));
                    values.put("gasolina", gasto.getString("gasolina"));
                    values.put("hotel", gasto.getString("hotel"));
                    values.put("alimentos", gasto.getString("alimentos"));
                    values.put("casetas", gasto.getString("casetas"));
                    values.put("total", gasto.getString("total"));

                    // Insertar el gasto en SQLite
                    long newRowId = db.insert("gastos", null, values);
                    Log.d("DEBUG", "Se insertó un nuevo gasto con ID " + id + ": " + newRowId);
                } else {
                    Log.d("DEBUG", "El gasto con ID " + id + " ya existe. No se insertó.");
                }
            }

        } catch (JSONException e) {
            e.printStackTrace();
            Log.e("ERROR", "Error procesando el reporte: " + e.getMessage());
        } finally {
            // Asegúrate de cerrar la base de datos
            db.close();
        }
    }

    // Método para insertar todos los campos
    private void insertAllFields(ContentValues values, JSONObject reporte) {
        try {
            values.put("poblacion_id", reporte.getString("poblacion_id"));
            values.put("estimacion", reporte.getString("estimacion"));
            values.put("abonos_semana", reporte.getString("abonos_semana"));
            values.put("recuperacion_semana", reporte.getString("recuperacion_semana"));
            values.put("recuperacion_vencida", reporte.getString("recuperacion_vencida"));
            values.put("anticipos", reporte.getString("anticipos"));
            values.put("total_1", reporte.getString("total_1"));
            values.put("recuperacion_prestamos", reporte.getString("recuperacion_prestamos"));
            values.put("colocacion", reporte.getString("colocacion"));
            values.put("prestamo_colocadora", reporte.getString("prestamo_colocadora"));
            values.put("comision", reporte.getString("comision"));
            values.put("bono_colocadora", reporte.getString("bono_colocadora"));
            values.put("total_2", reporte.getString("total_2"));
            values.put("saldo", reporte.getString("saldo"));
            values.put("pendiente_recuperar", reporte.getString("pendiente_recuperar"));
            values.put("abonos_recuperar", reporte.getString("abonos_recuperar"));
            values.put("comentario", reporte.getString("comentario"));
            values.put("empleado_id", reporte.getString("empleado_id"));
            values.put("gastos_id", reporte.getString("gastos_id"));
            values.put("fecha", reporte.getString("fecha"));
        } catch (JSONException e) {
            Log.e("ERROR", "Error insertando los campos del reporte: " + e.getMessage());
        }
    }

    private boolean existeGastoEnSQLite(SQLiteDatabase db, String id) {
        boolean existe = false;

        Cursor cursor = db.rawQuery("SELECT id FROM gastos WHERE id = ?", new String[]{id});
        if (cursor.moveToFirst()) {
            existe = true;
        }
        cursor.close();

        return existe;
    }


    private String getFechaRegistroSQLite(SQLiteDatabase db, String id) {
        String fecha_registro = "";

        Cursor cursor = db.rawQuery("SELECT fecha_registro FROM reporte_diario_rutas WHERE id = ?", new String[]{id});
        if (cursor.moveToFirst()) {
            fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
        }
        cursor.close();

        return fecha_registro;
    }



    private void getNuevoReporteDiarioRutasOnline() {
        dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteDiarioRutasAPP");
            data.put("empleado_id", sesion.getString("id", ""));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                JSONArray reportesArray = response.getJSONArray("data");

                                // Preparar arrays separados
                                JSONArray reporteArray = new JSONArray();
                                JSONArray gastosArray = new JSONArray();

                                // Separar datos de reportes y gastos
                                for (int i = 0; i < reportesArray.length(); i++) {
                                    JSONObject reporteCompleto = reportesArray.getJSONObject(i);

                                    // Extraer datos de reporte
                                    JSONObject reporte = new JSONObject();
                                    reporte.put("id", reporteCompleto.getString("id"));
                                    reporte.put("poblacion_id", reporteCompleto.getString("poblacion_id"));
                                    reporte.put("estimacion", reporteCompleto.getString("estimacion"));
                                    reporte.put("abonos_semana", reporteCompleto.getString("abonos_semana"));
                                    reporte.put("recuperacion_semana", reporteCompleto.getString("recuperacion_semana"));
                                    reporte.put("recuperacion_vencida", reporteCompleto.getString("recuperacion_vencida"));
                                    reporte.put("anticipos", reporteCompleto.getString("anticipos"));
                                    reporte.put("total_1", reporteCompleto.getString("total_1"));
                                    reporte.put("recuperacion_prestamos", reporteCompleto.getString("recuperacion_prestamos"));
                                    reporte.put("colocacion", reporteCompleto.getString("colocacion"));
                                    reporte.put("prestamo_colocadora", reporteCompleto.getString("prestamo_colocadora"));
                                    reporte.put("comision", reporteCompleto.getString("comision"));
                                    reporte.put("bono_colocadora", reporteCompleto.getString("bono_colocadora"));
                                    reporte.put("total_2", reporteCompleto.getString("total_2"));
                                    reporte.put("saldo", reporteCompleto.getString("saldo"));
                                    reporte.put("pendiente_recuperar", reporteCompleto.getString("pendiente_recuperar"));
                                    reporte.put("abonos_recuperar", reporteCompleto.getString("abonos_recuperar"));
                                    reporte.put("comentario", reporteCompleto.getString("comentario"));
                                    reporte.put("empleado_id", reporteCompleto.getString("empleado_id"));
                                    reporte.put("gastos_id", reporteCompleto.getString("gastos_id"));
                                    reporte.put("fecha", reporteCompleto.getString("fecha"));
                                    reporte.put("fecha_registro", reporteCompleto.getString("fecha_registro"));
                                    reporteArray.put(reporte);

                                    // Extraer datos de gastos
                                    JSONObject gasto = new JSONObject();
                                    gasto.put("id", reporteCompleto.getString("gastos_id"));
                                    gasto.put("otros", reporteCompleto.optString("otros", "0"));
                                    gasto.put("gasolina", reporteCompleto.optString("gasolina", "0"));
                                    gasto.put("hotel", reporteCompleto.optString("hotel", "0"));
                                    gasto.put("alimentos", reporteCompleto.optString("alimentos", "0"));
                                    gasto.put("casetas", reporteCompleto.optString("casetas", "0"));
                                    gasto.put("total", reporteCompleto.optString("total_gastos", "0"));
                                    gastosArray.put(gasto);
                                }

                                // Insertar datos en SQLite
                                insertarDatosEnSQLite(reporteArray, gastosArray);

                                dialog.dismiss();
                                Toast.makeText(getActivity(), "Datos sincronizados correctamente", Toast.LENGTH_SHORT).show();
                            } else {
                                dialog.dismiss();
                                Toast.makeText(getActivity(), "No se encontraron datos para sincronizar", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            dialog.dismiss();
                            e.printStackTrace();
                            Toast.makeText(getActivity(), "Error al procesar datos del servidor", Toast.LENGTH_SHORT).show();
                        }
                    }

                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void insertarDatosEnSQLite(JSONArray reporteArray, JSONArray gastosArray) {
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        try {
            db.beginTransaction(); // Inicia una transacción para mejorar el rendimiento

            // Insertar reportes en la tabla `reporte_diario_rutas`
            for (int i = 0; i < reporteArray.length(); i++) {
                JSONObject reporte = reporteArray.getJSONObject(i);
                ContentValues values = new ContentValues();

                values.put("id", reporte.getString("id"));
                values.put("poblacion_id", reporte.getString("poblacion_id"));
                values.put("estimacion", reporte.getString("estimacion"));
                values.put("abonos_semana", reporte.getString("abonos_semana"));
                values.put("recuperacion_semana", reporte.getString("recuperacion_semana"));
                values.put("recuperacion_vencida", reporte.getString("recuperacion_vencida"));
                values.put("anticipos", reporte.getString("anticipos"));
                values.put("total_1", reporte.getString("total_1"));
                values.put("recuperacion_prestamos", reporte.getString("recuperacion_prestamos"));
                values.put("colocacion", reporte.getString("colocacion"));
                values.put("prestamo_colocadora", reporte.getString("prestamo_colocadora"));
                values.put("comision", reporte.getString("comision"));
                values.put("bono_colocadora", reporte.getString("bono_colocadora"));
                values.put("total_2", reporte.getString("total_2"));
                values.put("saldo", reporte.getString("saldo"));
                values.put("pendiente_recuperar", reporte.getString("pendiente_recuperar"));
                values.put("abonos_recuperar", reporte.getString("abonos_recuperar"));
                values.put("comentario", reporte.getString("comentario"));
                values.put("empleado_id", reporte.getString("empleado_id"));
                values.put("gastos_id", reporte.getString("gastos_id"));
                values.put("fecha", reporte.getString("fecha"));
                values.put("fecha_registro", reporte.getString("fecha_registro"));

                db.insertWithOnConflict("reporte_diario_rutas", null, values, SQLiteDatabase.CONFLICT_REPLACE);
            }

            // Insertar gastos en la tabla `gastos`
            for (int i = 0; i < gastosArray.length(); i++) {
                JSONObject gasto = gastosArray.getJSONObject(i);
                ContentValues values = new ContentValues();

                values.put("id", gasto.getString("id"));
                values.put("otros", gasto.getString("otros"));
                values.put("gasolina", gasto.getString("gasolina"));
                values.put("hotel", gasto.getString("hotel"));
                values.put("alimentos", gasto.getString("alimentos"));
                values.put("casetas", gasto.getString("casetas"));
                values.put("total", gasto.getString("total"));

                db.insertWithOnConflict("gastos", null, values, SQLiteDatabase.CONFLICT_REPLACE);
            }

            db.setTransactionSuccessful(); // Marca la transacción como exitosa
        } catch (JSONException e) {
            e.printStackTrace();
        } finally {
            db.endTransaction(); // Finaliza la transacción
            db.close();
        }
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "ReporteDiarioFragment";
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);

        initElements(view);

        // Verificar si la tabla 'reporte_creditos' existe y tiene más de un registro
        if (isTableExistsAndHasData("reporte_diario_rutas")) {
            getNuevoReporteDiarioRutasOnlineUpd();
        } else
        {
            getNuevoReporteDiarioRutasOnlineUpd();
        }

    }
    private boolean isTableExistsAndHasData(String tableName) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean result = false;

        try {
            // Abrir base de datos en modo lectura
            db = new DatabaseHelper(getActivity()).getReadableDatabase();

            // Consulta para verificar si la tabla existe
            String queryTableExists = "SELECT name FROM sqlite_master WHERE type='table' AND name=?";
            cursor = db.rawQuery(queryTableExists, new String[]{tableName});

            if (cursor.getCount() > 0) { // La tabla existe
                cursor.close(); // Cerrar el cursor para reutilizar

                // Consulta para verificar si la tabla tiene más de un registro
                String queryTableHasData = "SELECT COUNT(*) FROM " + tableName;
                cursor = db.rawQuery(queryTableHasData, null);

                if (cursor.moveToFirst()) {
                    int rowCount = cursor.getInt(0); // Obtiene el conteo de registros
                    result = rowCount > 0; // Devuelve true si hay al menos un registro
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }

        return result;
    }

    public void initElements(View view){

        poblacionesReporte = new ArrayList<>();
        reporteDiariosFiltrado = new ArrayList<>();
        poblacionController = new PoblacionController(getActivity());


        svPoblaciones = view.findViewById(R.id.svPoblaciones);

        svPoblaciones.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                filtrarReportePoblaciones(editable.toString());
            }
        });

        rutaController = new RutaController(getActivity());
        gastosController = new GastosController(getActivity());
        reportediarioderutasController = new ReporteDiarioDeRutasController(getActivity());
        recyclerView = view.findViewById(R.id.rvReporteDiario);
        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        reporteDiarios = new ArrayList<>();
        reportesAgregados = new ArrayList<>();

        rutas = new ArrayList<Ruta>();

        gastos = new Gastos();
        if (verificarTablaExiste("gastos")) {
            Log.d("DEBUG", "La tabla 'gastos' existe.");
        } else {
            Log.d("DEBUG", "La tabla 'gastos' no existe.");
        }
        if (verificarTablaExiste("reporte_diario_rutas")) {
            Log.d("DEBUG", "La tabla 'reporte_diario_rutas' existe.");
        } else {
            Log.d("DEBUG", "La tabla 'reporte_diario_rutas' no existe.");
        }

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);
        reporteDiarioAdapter = new ReporteDiarioAdapter(getActivity(), reporteDiarios);
        recyclerView.setAdapter(reporteDiarioAdapter);

        btnGastos = view.findViewById(R.id.btnGastos);
        btnGuardar = view.findViewById(R.id.btnGuardar);
        btnTotales = view.findViewById(R.id.btnTotales);
        btnAgregar = view.findViewById(R.id.btnAgregar);

        tlFecha = view.findViewById(R.id.tlFecha);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlNombre = view.findViewById(R.id.tlNombre);

        tlNombre.getEditText().setText(sesion.getString("nombre", ""));

        tlFecha.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();

                materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                materialDatePicker.addOnPositiveButtonClickListener(
                    new MaterialPickerOnPositiveButtonClickListener() {

                        @SuppressLint("SetTextI18n")
                        @Override
                        public void onPositiveButtonClick(Object selection) {

                            TimeZone timeZoneUTC = TimeZone.getDefault();
                            int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                            Date date = new Date((Long) selection + offsetFromUTC);

                            tlFecha.getEditText().setText(simpleFormat.format(date));
                        }
                    });
            }
        });

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();
                filtrarReporte(ruta_id);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    reporteDiarioAdapter.setListaFiltrada(reporteDiarios);
                }

            }
        });

        new MaterialAlertDialogBuilder(getActivity())
                .setCancelable(false)
                .setTitle("Opciones")
                .setPositiveButton("Nuevo reporte", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        buscarReporte = false;
                        reporteDiarioAdapter.setBuscarReporte(false);

                        // Convertir rutaIdSesion en una lista de números
                        String rutaIdSesion = sesion.getString("rutas", "");
                        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

                        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
                        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

                        // Buscar el valor más pequeño
                        Integer rutaMinima = null;
                        try {
                            List<Integer> rutaIdsNumericos = null; // Recolectar como lista
                            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                rutaIdsNumericos = rutaIdsSesion.stream()
                                        .filter(id -> !id.trim().isEmpty()) // Filtrar valores vacíos
                                        .map(Integer::parseInt) // Convertir a enteros
                                        .collect(Collectors.toList());
                            }

                            rutaMinima = Collections.min(rutaIdsNumericos); // Obtener el valor mínimo
                            Log.d("getRutas", "Ruta mínima: " + rutaMinima);
                        } catch (NumberFormatException e) {
                            Log.e("getRutas", "Error al convertir ruta IDs a enteros", e);
                        }

                        // Pasar la ruta mínima en lugar de null
                        getNuevoReporteDiarioRutas(null);
                    }
                })

            .setNegativeButton("Buscar", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {

                    buscarReporte = true;
                    reporteDiarioAdapter.setBuscarReporte(true);

                    tlFecha.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            if(Validator.fieldValidation(tlRuta, "Ingresa una ruta")
                            ){
                                getReporteDiarioRutas(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
                            }

                        }
                    });

                }
            })
            .show();

        btnAgregar.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View view) {
                final View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_reporte_diario_rutas_2, null, false);


                AutoCompleteTextView poblacionesAutoCompleteTextView = dialogView.findViewById(R.id.acPoblacion);
                TextInputLayout tlEstimacion = dialogView.findViewById(R.id.tlEstimacion);
                TextInputLayout tlAbonosSemana = dialogView.findViewById(R.id.tlAbonosSemana);
                TextInputLayout tlRecupSemana = dialogView.findViewById(R.id.tlRecupSemana);
                TextInputLayout tlAnticipos = dialogView.findViewById(R.id.tlAnticipos);
                TextInputLayout tlTotal1 = dialogView.findViewById(R.id.tlTotal1);
                TextInputLayout tlRecupPrestamos = dialogView.findViewById(R.id.tlRecupPrestamos);
                TextInputLayout tlColocacion = dialogView.findViewById(R.id.tlColocacion);
                TextInputLayout tlPrestamoColocadora = dialogView.findViewById(R.id.tlPrestamoColocadora);
                TextInputLayout tlComision = dialogView.findViewById(R.id.tlComision);
                TextInputLayout tlBonoColocadora = dialogView.findViewById(R.id.tlBonoColocadora);
                TextInputLayout tlTotal2 = dialogView.findViewById(R.id.tlTotal2);
                TextInputLayout tlSaldo = dialogView.findViewById(R.id.tlSaldo);
                TextInputLayout tlPendienteRecup = dialogView.findViewById(R.id.tlPendienteRecup);
                TextInputLayout tlAbonosRecup = dialogView.findViewById(R.id.tlAbonosRecup);

                final int[] total1 = {0};
                final int[] total2 = {0};
                final int[] saldo = {0};

                tlRecupSemana.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total1[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlAnticipos.getEditText().getText().toString().equals("") ? "0" : tlAnticipos.getEditText().getText().toString()));

                        tlTotal1.getEditText().setText(String.valueOf(total1[0]));

                    }
                });

                tlAnticipos.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total1[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlRecupSemana.getEditText().getText().toString().equals("") ? "0" : tlRecupSemana.getEditText().getText().toString()));

                        tlTotal1.getEditText().setText(String.valueOf(total1[0]));

                    }
                });


                tlColocacion.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()))
                                + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                        tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                    }
                });

                tlPrestamoColocadora.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()))
                                + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                        tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                    }
                });

                tlComision.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                + Integer.parseInt((tlBonoColocadora.getEditText().getText().toString().equals("") ? "0" : tlBonoColocadora.getEditText().getText().toString()));

                        tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                    }
                });

                tlBonoColocadora.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        total2[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                + Integer.parseInt((tlPrestamoColocadora.getEditText().getText().toString().equals("") ? "0" : tlPrestamoColocadora.getEditText().getText().toString()))
                                + Integer.parseInt((tlColocacion.getEditText().getText().toString().equals("") ? "0" : tlColocacion.getEditText().getText().toString()))
                                + Integer.parseInt((tlComision.getEditText().getText().toString().equals("") ? "0" : tlComision.getEditText().getText().toString()));

                        tlTotal2.getEditText().setText(String.valueOf(total2[0]));

                    }
                });

                /*tlTotal1.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        saldo[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                - Integer.parseInt((tlTotal2.getEditText().getText().toString().equals("") ? "0" : tlTotal2.getEditText().getText().toString()));

                        tlSaldo.getEditText().setText(String.valueOf(saldo[0]));

                    }
                });*/

                tlTotal2.getEditText().addTextChangedListener(new TextWatcher() {
                    @Override
                    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                    }

                    @Override
                    public void afterTextChanged(Editable editable) {

                        saldo[0] = Integer.parseInt((tlTotal1.getEditText().getText().toString().equals("") ? "0" : tlTotal1.getEditText().getText().toString()))
                                - Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()));

                        tlSaldo.getEditText().setText(String.valueOf(saldo[0]));

                    }
                });


                /**
                 *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
                 */

                poblacionesReporte.clear();
                if (poblacionesReporte.size() == 0) {
                    getPoblaciones(ruta_id, poblacionesAutoCompleteTextView);
                }

                poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @RequiresApi(api = Build.VERSION_CODES.N)
                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                        ReporteDiario reporteDiario = poblacionesAdapter.getItem(i);
                        poblacion_nombre = reporteDiario.getNombre_poblacion();
                        poblacion_id = reporteDiario.getPoblacion_id();
                        poblacion_nombre = reporteDiario.getNombre_poblacion();
                        estimado_poblacion = reporteDiario.getEstimado();
                        tlEstimacion.getEditText().setText(estimado_poblacion);

                    }
                });

                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Agregar registro al reporte")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(!poblacion_id.equals("")){

                                    Log.d("ReporteDiarioFragment", "Dato en Agregar registro al reporte>Guardar. ID GASTOS" + gastos_id);
                                    ReporteDiario nuevoRegistro = new ReporteDiario(
                                            "", poblacion_id,
                                            tlEstimacion.getEditText().getText().toString(),
                                            "",
                                            tlAbonosSemana.getEditText().getText().toString(),
                                            tlRecupSemana.getEditText().getText().toString(),
                                            tlAnticipos.getEditText().getText().toString(),
                                            tlTotal1.getEditText().getText().toString(),
                                            tlRecupPrestamos.getEditText().getText().toString(),
                                            tlColocacion.getEditText().getText().toString(),
                                            tlPrestamoColocadora.getEditText().getText().toString(),
                                            tlComision.getEditText().getText().toString(),
                                            tlBonoColocadora.getEditText().getText().toString(),
                                            tlTotal2.getEditText().getText().toString(),
                                            tlSaldo.getEditText().getText().toString(),
                                            tlPendienteRecup.getEditText().getText().toString(),
                                            tlAbonosRecup.getEditText().getText().toString(),
                                            "","",gastos_id,"","",reporteDiarios.get(0).getComentario()
                                            );

                                    nuevoRegistro.setNombre_poblacion(poblacion_nombre);
                                    nuevoRegistro.setSeleccionado(true);

                                    reportesAgregados.add(nuevoRegistro);
                                    reporteDiarios.add(nuevoRegistro);

                                    reporteDiarioAdapter.addAll(reporteDiarios);
                                    reporteDiarioAdapter.notifyItemRangeChanged(reporteDiarios.size(), 1);

                                    poblacion_id = "";
                                    poblacion_nombre = "";

                                }
                                else{

                                    Toast.makeText(getActivity(), "Selecciona una población", Toast.LENGTH_SHORT).show();

                                }



                            }
                        })
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();

            }
        });


        btnGastos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                final int[] totalGastos = {0};

                final View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_gastos, null, false);

                TextInputLayout tlOtros = dialogView.findViewById(R.id.tlOtros);
                TextInputLayout tlGasolina = dialogView.findViewById(R.id.tlGasolina);
                TextInputLayout tlHotel = dialogView.findViewById(R.id.tlHotel);
                TextInputLayout tlAlimentos = dialogView.findViewById(R.id.tlAlimentos);
                TextInputLayout tlCasetas = dialogView.findViewById(R.id.tlCasetas);
                TextInputLayout tlTotal = dialogView.findViewById(R.id.tlTotal);

                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getOtros.............." + gastos.getOtros());
                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getGasolina.............." + gastos.getGasolina());
                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getHotel.............." + gastos.getHotel());
                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getAlimentos.............." + gastos.getAlimentos());
                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getCasetas.............." + gastos.getCasetas());
                Log.d("ReporteDiarioFragment", "Datos para llenar campo de getTotal.............." + gastos.getTotal());

                tlOtros.getEditText().setText(gastos.getOtros());
                tlGasolina.getEditText().setText(gastos.getGasolina());
                tlHotel.getEditText().setText(gastos.getHotel());
                tlAlimentos.getEditText().setText(gastos.getAlimentos());
                tlCasetas.getEditText().setText(gastos.getCasetas());
                tlTotal.getEditText().setText(gastos.getTotal());

                /*if(buscarReporte){

                    new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Gastos")
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();
                }
                else{*/

                    tlOtros.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            totalGastos[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()))
                                    + Integer.parseInt((tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()))
                                    + Integer.parseInt((tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()))
                                    + Integer.parseInt((tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString() ));

                            tlTotal.getEditText().setText(String.valueOf(totalGastos[0]));

                        }
                    });

                    tlGasolina.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            totalGastos[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()))
                                    + Integer.parseInt((tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()))
                                    + Integer.parseInt((tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()))
                                    + Integer.parseInt((tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString() ));

                            tlTotal.getEditText().setText(String.valueOf(totalGastos[0]));

                        }
                    });

                    tlHotel.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            totalGastos[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()))
                                    + Integer.parseInt((tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()))
                                    + Integer.parseInt((tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()))
                                    + Integer.parseInt((tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString() ));

                            tlTotal.getEditText().setText(String.valueOf(totalGastos[0]));

                        }
                    });

                    tlAlimentos.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {



                        }

                        @Override
                        public void afterTextChanged(Editable editable) {

                            totalGastos[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()))
                                    + Integer.parseInt((tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()))
                                    + Integer.parseInt((tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString()))
                                    + Integer.parseInt((tlCasetas.getEditText().getText().toString().equals("") ? "0" : tlCasetas.getEditText().getText().toString() ));

                            tlTotal.getEditText().setText(String.valueOf(totalGastos[0]));

                        }
                    });

                    tlCasetas.getEditText().addTextChangedListener(new TextWatcher() {
                        @Override
                        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                        }

                        @Override
                        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {


                        }

                        @Override
                        public void afterTextChanged(Editable editable) {
                            totalGastos[0] = Integer.parseInt((editable.toString().equals("") ? "0" : editable.toString()))
                                    + Integer.parseInt((tlGasolina.getEditText().getText().toString().equals("") ? "0" : tlGasolina.getEditText().getText().toString()))
                                    + Integer.parseInt((tlHotel.getEditText().getText().toString().equals("") ? "0" : tlHotel.getEditText().getText().toString()))
                                    + Integer.parseInt((tlAlimentos.getEditText().getText().toString().equals("") ? "0" : tlAlimentos.getEditText().getText().toString()))
                                    + Integer.parseInt((tlOtros.getEditText().getText().toString().equals("") ? "0" : tlOtros.getEditText().getText().toString() ));

                            tlTotal.getEditText().setText(String.valueOf(totalGastos[0]));
                        }
                    });


                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Gastos")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(buscarReporte){
                                    Log.d("ReporteDiarioFragment", "Dato en Gastos>Guardar. ID GASTOS" + gastos_id);
                                    gastos.setId(gastos_id);
                                }
                                gastos.setOtros(tlOtros.getEditText().getText().toString());
                                gastos.setGasolina(tlGasolina.getEditText().getText().toString());
                                gastos.setHotel(tlHotel.getEditText().getText().toString());
                                gastos.setAlimentos(tlAlimentos.getEditText().getText().toString());
                                gastos.setCasetas(tlCasetas.getEditText().getText().toString());
                                gastos.setTotal(tlTotal.getEditText().getText().toString());

                            }
                        })
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();

                    /*if(buscarReporte){

                        new MaterialAlertDialogBuilder(getActivity())
                                .setCancelable(false)
                                .setView(dialogView)
                                .setTitle("Gastos")
                                .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                        gastos.setId(gastos_id);
                                        gastos.setOtros(tlOtros.getEditText().getText().toString());
                                        gastos.setGasolina(tlGasolina.getEditText().getText().toString());
                                        gastos.setHotel(tlHotel.getEditText().getText().toString());
                                        gastos.setAlimentos(tlAlimentos.getEditText().getText().toString());
                                        gastos.setCasetas(tlCasetas.getEditText().getText().toString());
                                        gastos.setTotal(tlTotal.getEditText().getText().toString());

                                    }
                                })
                                .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                    }
                                })
                                .show();

                    }
                    else{

                        new MaterialAlertDialogBuilder(getActivity())
                                .setCancelable(false)
                                .setView(dialogView)
                                .setTitle("Gastos")
                                .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                        gastos.setOtros(tlOtros.getEditText().getText().toString());
                                        gastos.setGasolina(tlGasolina.getEditText().getText().toString());
                                        gastos.setHotel(tlHotel.getEditText().getText().toString());
                                        gastos.setAlimentos(tlAlimentos.getEditText().getText().toString());
                                        gastos.setCasetas(tlCasetas.getEditText().getText().toString());
                                        gastos.setTotal(tlTotal.getEditText().getText().toString());

                                    }
                                })
                                .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialogInterface, int i) {

                                    }
                                })
                                .show();

                    }*/


                //}


            }
        });

        btnTotales.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View view) {

                final View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_totales, null, false);

                TextView tvEstimacion = dialogView.findViewById(R.id.tvEstimacion);
                TextView tvAbonosSemana = dialogView.findViewById(R.id.tvAbonosSemana);
                TextView tvRecupSemana = dialogView.findViewById(R.id.tvRecupSemana);
                TextView tvAnticipos = dialogView.findViewById(R.id.tvAnticipos);
                TextView tvTotal1 = dialogView.findViewById(R.id.tvTotal1);
                TextView tvRecupPrestamos = dialogView.findViewById(R.id.tvRecupPrestamos);
                TextView tvColocacion = dialogView.findViewById(R.id.tvColocacion);
                TextView tvPrestamoColocadora = dialogView.findViewById(R.id.tvPrestamoColocadora);
                TextView tvComision = dialogView.findViewById(R.id.tvComision);
                TextView tvBonoColocadora = dialogView.findViewById(R.id.tvBonoColocadora);
                TextView tvTotal2= dialogView.findViewById(R.id.tvTotal2);
                TextView tvSaldo = dialogView.findViewById(R.id.tvSaldo);
                TextView tvPendienteRecup = dialogView.findViewById(R.id.tvPendienteRecup);
                TextView tvAbonosRecup = dialogView.findViewById(R.id.tvAbonosRecup);
                TextView tvTotalEntregado = dialogView.findViewById(R.id.tvTotalEntregado);
                TextView tvComentario = dialogView.findViewById(R.id.tvComentario);

                TextInputLayout tlComentario = dialogView.findViewById(R.id.tlComentario);

                if(buscarReporte){

                    //tlComentario.setVisibility(View.GONE);
                    //tvComentario.setVisibility(View.VISIBLE);

                    if(reporteDiarios.size() > 0){
                        tlComentario.getEditText().setText(reporteDiarios.get(0).getComentario());
                    }

                    double estimacionTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getEstimacion()))
                            .sum();
                    tvEstimacion.setText(Html.fromHtml("<b>Estimación: </b> $"+estimacionTotal));

                    double abonosSemTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAbonos_semana()))
                            .sum();
                    tvAbonosSemana.setText(Html.fromHtml("<b>Abonos semana:</b> $"+abonosSemTotal));

                    double recupSemTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_semana()))
                            .sum();
                    tvRecupSemana.setText(Html.fromHtml("<b>Recup. semana:</b> $"+recupSemTotal));

                    double anticiposTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAnticipos()))
                            .sum();
                    tvAnticipos.setText(Html.fromHtml("<b>Anticipos:</b> $"+anticiposTotal));

                    double total1Total = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getTotal_1()))
                            .sum();
                    tvTotal1.setText(Html.fromHtml("<b>Total:</b> $"+total1Total));

                    double recupPrestamosTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_prestamos()))
                            .sum();
                    tvRecupPrestamos.setText(Html.fromHtml("<b>Recup. prestamos:</b> $"+recupPrestamosTotal));

                    double colocacionTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getColocacion()))
                            .sum();
                    tvColocacion.setText(Html.fromHtml("<b>Colocacion:</b> $"+colocacionTotal));

                    double prestColocadoraTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getPrestamo_colocadora()))
                            .sum();
                    tvPrestamoColocadora.setText(Html.fromHtml("<b>Prest. colocadora:</b> $"+ prestColocadoraTotal));

                    double comisionTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getComision()))
                            .sum();
                    tvComision.setText(Html.fromHtml("<b>Comisión:</b> $"+ comisionTotal));

                    double bonoColocadoraTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getBono_colocadora()))
                            .sum();
                    tvBonoColocadora.setText(Html.fromHtml("<b>Bono colocadora:</b>  $"+ bonoColocadoraTotal));

                    double total2Total = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getTotal_2()))
                            .sum();
                    tvTotal2.setText(Html.fromHtml("<b>Total:</b> $"+total2Total));

                    double saldoTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getSaldo()))
                            .sum();
                    tvSaldo.setText(Html.fromHtml("<b>Saldo:</b> $"+saldoTotal));

                    double pendienteRecuperarTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getPendiente_recuperar()))
                            .sum();
                    tvPendienteRecup.setText(Html.fromHtml("<b>Pendiente. recup:</b> $"+pendienteRecuperarTotal));

                    double abonosRecuperarTotal = reporteDiarios.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAbonos_recuperar()))
                            .sum();
                    tvAbonosRecup.setText(Html.fromHtml("<b>Abonos. recup:</b> "+abonosRecuperarTotal));

                    double total_entregado = total1Total - total2Total;

                    tvTotalEntregado.setText(Html.fromHtml("<b>Total a entregar:</b> $" + total_entregado));

                   /* new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Totales")
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        })
                        .show();*/

                }else{

                    if(reporteDiarioAdapter.reportesSeleccionados.size() > 0){
                        tlComentario.getEditText().setText(reporteDiarioAdapter.reportesSeleccionados.get(0).getComentario());
                    }

                    double estimacionTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getEstimacion()))
                            .sum();
                    tvEstimacion.setText(Html.fromHtml("<b>Estimación: </b> $"+estimacionTotal));

                    double abonosSemTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAbonos_semana()))
                            .sum();
                    tvAbonosSemana.setText(Html.fromHtml("<b>Abonos semana:</b> $"+abonosSemTotal));

                    double recupSemTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_semana()))
                            .sum();
                    tvRecupSemana.setText(Html.fromHtml("<b>Recup. semana:</b> $"+recupSemTotal));

                    double anticiposTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAnticipos()))
                            .sum();
                    tvAnticipos.setText(Html.fromHtml("<b>Anticipos:</b> $"+anticiposTotal));

                    double total1Total = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getTotal_1()))
                            .sum();
                    tvTotal1.setText(Html.fromHtml("<b>Total:</b> $"+total1Total));

                    double recupPrestamosTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getRecuperacion_prestamos()))
                            .sum();
                    tvRecupPrestamos.setText(Html.fromHtml("<b>Recup. prestamos:</b> $"+recupPrestamosTotal));

                    double colocacionTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getColocacion()))
                            .sum();
                    tvColocacion.setText(Html.fromHtml("<b>Colocacion:</b> $"+colocacionTotal));

                    double prestColocadoraTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getPrestamo_colocadora()))
                            .sum();
                    tvPrestamoColocadora.setText(Html.fromHtml("<b>Prest. colocadora:</b> $"+ prestColocadoraTotal));

                    double comisionTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getComision()))
                            .sum();
                    tvComision.setText(Html.fromHtml("<b>Comisión:</b> $"+ comisionTotal));

                    double bonoColocadoraTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getBono_colocadora()))
                            .sum();
                    tvBonoColocadora.setText(Html.fromHtml("<b>Bono colocadora:</b>  $"+ bonoColocadoraTotal));

                    double total2Total = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getTotal_2()))
                            .sum();
                    tvTotal2.setText(Html.fromHtml("<b>Total:</b> $"+total2Total));

                    double saldoTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getSaldo()))
                            .sum();
                    tvSaldo.setText(Html.fromHtml("<b>Saldo:</b> $"+saldoTotal));

                    double pendienteRecuperarTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getPendiente_recuperar()))
                            .sum();
                    tvPendienteRecup.setText(Html.fromHtml("<b>Pendiente. recup:</b> $"+pendienteRecuperarTotal));

                    double abonosRecuperarTotal = reporteDiarioAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getAbonos_recuperar()))
                            .sum();
                    tvAbonosRecup.setText(Html.fromHtml("<b>Abonos. recup:</b> "+abonosRecuperarTotal));

                    double total_entregado = total1Total - total2Total;

                    tvTotalEntregado.setText(Html.fromHtml("<b>Total a entregar:</b> $" + total_entregado));

                }

                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Totales")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(buscarReporte){
                                    for(ReporteDiario rd: reporteDiarios){
                                        rd.setComentario(tlComentario.getEditText().getText().toString());
                                    }

                                    agregarComentario(tlComentario.getEditText().getText().toString(), tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
                                }
                                else{
                                    for(ReporteDiario rd: reporteDiarioAdapter.reportesSeleccionados){
                                        rd.setComentario(tlComentario.getEditText().getText().toString());
                                    }
                                }


                            }
                        })
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();

            }
        });

        btnGuardar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                    new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setTitle("Guardar reporte")
                        .setMessage("¿Esta seguro de guardar el reporte?")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(Validator.fieldValidation(tlRuta, "Ingresa una ruta") &&
                                        Validator.fieldValidation(tlFecha, "Ingresa una fecha")
                                ){

                                    if(buscarReporte){

                                        if(reporteDiarios.size() > 0){

                                            editarGastos(gastos);

                                            if(reportesAgregados.size() > 0){

                                                for(ReporteDiario rd: reportesAgregados){
                                                    rd.setSeleccionado(false);
                                                    agregarRegistroReporte(rd);
                                                }

                                                reportesAgregados.clear();

                                                Toast.makeText(getActivity(), "Se agregaron registros al reporte", Toast.LENGTH_SHORT).show();

                                            }
                                            else{

                                                if(reporteDiarioAdapter.reportesEditados.size() > 0){

                                                    for(ReporteDiario rd: reporteDiarioAdapter.reportesEditados){
                                                        editarRegistroReporte(rd);
                                                    }

                                                    reporteDiarioAdapter.reportesEditados.clear();

                                                    Toast.makeText(getActivity(), "Se editaron registros del reporte", Toast.LENGTH_SHORT).show();

                                                }
                                                else{
                                                    Toast.makeText(getActivity(), "No se editaron nuevos registros", Toast.LENGTH_SHORT).show();
                                                }
                                                Toast.makeText(getActivity(), "No se agregaron nuevos registros", Toast.LENGTH_SHORT).show();
                                            }





                                        }
                                        else
                                        {
                                            Log.d("getRutas", "ELSE DE buscarReporte............: " + buscarReporte);
                                        }


                                    }
                                    else{
                                        Log.d("getRutas", "reporteDiarios.size() de la sesión descompuestos: " + reporteDiarios.size());
                                        if(reporteDiarioAdapter.reportesSeleccionados.size() > 0){
                                            Log.d("getRutas", "ENTRO EN IF DE reporteDiarioAdapter.reportesSeleccionados: ");
                                            registrarGastos(gastos);
                                        }
                                        else{
                                            Toast.makeText(getActivity(), "No hay poblaciones seleccionadas", Toast.LENGTH_SHORT).show();
                                        }
                                    }

                                }

                            }
                        })
                        .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                            }
                        })
                        .show();
            }
        });
    }
    public boolean verificarTablaExiste(String nombreTabla) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean existe = false;

        try {
            // Abre la base de datos en modo lectura
            db = new DatabaseHelper(getContext()).getReadableDatabase();

            // Consulta en la tabla sqlite_master para verificar si la tabla existe
            cursor = db.rawQuery(
                    "SELECT name FROM sqlite_master WHERE type='table' AND name=?",
                    new String[]{nombreTabla}
            );

            // Si el cursor devuelve resultados, la tabla existe
            existe = cursor != null && cursor.getCount() > 0;
        } catch (Exception e) {
            Log.e("ERROR", "Error al verificar si la tabla existe: " + nombreTabla, e);
        } finally {
            // Cierra el cursor y la base de datos
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }

        return existe;
    }
    public void getRutas()
    {
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        if(rutaController.obtener().size() == 0){

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for(int i = 0; i < data.length(); i++){

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }

                                }

                                rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            }) ;

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            // Recuperar las rutas de la base de datos local y filtrar por los IDs en la sesión
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);

        }

    }

    private void getNuevoReporteDiarioRutas(String rutaId) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Log.d("SQLiteError", "Entro en la consulta local getNuevoReporteDiarioRutas: " + rutaId);

        // Abrir base de datos
        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Construir consulta
        String query = "SELECT TABLA_ESTIMADOS.poblacion_id, TABLA_ESTIMADOS.ruta_id, TABLA_ESTIMADOS.nombre_poblacion, " +
                "TABLA_ESTIMADOS.modalidad_semanas, " +
                "SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, " +
                "'' AS estimacion, '' AS abonos_semana, '' AS recuperacion_semana, '' AS anticipos, '' AS total_1, " +
                "'' AS recuperacion_prestamos, '' AS colocacion, '' AS prestamo_colocadora, '' AS comision, '' AS bono_colocadora, " +
                "'' AS total_2, '' AS saldo, '' AS pendiente_recuperar, " +
                "'' AS abonos_recuperar, '' AS empleado_id, '' AS gastos_id, '' AS fecha, '' AS fecha_registro " +
                "FROM ( " +
                "  SELECT pagos.cantidad_esperada_pago, pagos.semana, poblaciones.primer_dia_cobro, " +
                "         MAX(CASE WHEN pagos.fecha_pago >= date('now') AND pagos.fecha_pago < date('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago, " +
                "         clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, prestamos.modalidad_semanas, " +
                "         poblaciones.nombre_poblacion, rutas.nombre_ruta, prestamos.status, prestamos.updated_at " +
                "  FROM pagos " +
                "  INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                "  INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                "  INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                "  INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                "  WHERE (CASE WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0, 2) ELSE prestamos.status = 0 END) " +
                (rutaId != null && !rutaId.isEmpty() ? " AND clientes.ruta_id = ? " : "") +
                "  GROUP BY prestamos.id " +
                "  ORDER BY clientes.poblacion_id DESC " +
                ") AS TABLA_ESTIMADOS " +
                "GROUP BY TABLA_ESTIMADOS.nombre_poblacion " +
                "ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";

        Cursor cursor;
        try {
            if (rutaId != null && !rutaId.isEmpty()) {
                cursor = db.rawQuery(query, new String[]{rutaId});
            } else {
                cursor = db.rawQuery(query, null);
            }
            Log.d("SQLiteState", "Consulta ejecutada correctamente, rutaId: " + rutaId);
        } catch (Exception e) {
            Log.e("SQLiteError", "Error al ejecutar la consulta", e);
            dialog.dismiss();
            return;
        }

        // Procesar resultados
        reporteDiarios.clear();

        if (cursor != null && cursor.moveToFirst()) {
            Log.d("SQLiteData", "Resultados obtenidos de la consulta");
            do {
                ReporteDiario reporteDiario = new ReporteDiario();

                String poblacionId = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                Log.d("ReporteDiarioField", "...........................poblacion_id=" + poblacionId);
                // Campos principales de TABLA_ESTIMADOS
                reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                //reporteDiario.setModalidadSemanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));

                // Campos vacíos del SELECT
                reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion"))); // Por defecto vacío
                reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana"))); // Por defecto vacío
                reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana"))); // Por defecto vacío
                reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos"))); // Por defecto vacío
                reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1"))); // Por defecto vacío
                reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos"))); // Por defecto vacío
                reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion"))); // Por defecto vacío
                reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora"))); // Por defecto vacío
                reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision"))); // Por defecto vacío
                reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora"))); // Por defecto vacío
                reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2"))); // Por defecto vacío
                reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo"))); // Por defecto vacío
                reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar"))); // Por defecto vacío
                reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar"))); // Por defecto vacío
                reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"))); // Por defecto vacío
                reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"))); // Por defecto vacío
                reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha"))); // Por defecto vacío
                reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"))); // Por defecto vacío

                reporteDiarios.add(reporteDiario);

                // Registrar en el log los valores obtenidos
                Log.d("ReporteDiario", "Fila obtenida: " +
                        "poblacion_id=" + reporteDiario.getPoblacion_id() +
                        ", ruta_id=" + reporteDiario.getRuta_id() +
                        ", nombre_poblacion=" + reporteDiario.getNombre_poblacion() +
                        ", estimado=" + reporteDiario.getEstimado() +
                        ", estimacion=" + reporteDiario.getEstimacion() +
                        ", abonos_semana=" + reporteDiario.getAbonos_semana() +
                        ", recuperacion_semana=" + reporteDiario.getRecuperacion_semana() +
                        ", anticipos=" + reporteDiario.getAnticipos() +
                        ", total_1=" + reporteDiario.getTotal_1() +
                        ", recuperacion_prestamos=" + reporteDiario.getRecuperacion_prestamos() +
                        ", colocacion=" + reporteDiario.getColocacion() +
                        ", prestamo_colocadora=" + reporteDiario.getPrestamo_colocadora() +
                        ", comision=" + reporteDiario.getComision() +
                        ", bono_colocadora=" + reporteDiario.getBono_colocadora() +
                        ", total_2=" + reporteDiario.getTotal_2() +
                        ", saldo=" + reporteDiario.getSaldo() +
                        ", pendiente_recuperar=" + reporteDiario.getPendiente_recuperar() +
                        ", abonos_recuperar=" + reporteDiario.getAbonos_recuperar() +
                        ", empleado_id=" + reporteDiario.getEmpleado_id() +
                        ", gastos_id=" + reporteDiario.getGastos_id() +
                        ", fecha=" + reporteDiario.getFecha() +
                        ", fecha_registro=" + reporteDiario.getFecha_registro());

            } while (cursor.moveToNext());
        } else {
            Log.d("SQLiteData", "No se encontraron resultados");
        }

        // Cerrar cursor y base de datos
        if (cursor != null) cursor.close();
        db.close();
        btnGastos.setVisibility(View.VISIBLE);
        btnTotales.setVisibility(View.VISIBLE);
        btnGuardar.setVisibility(View.VISIBLE);
        // Actualizar adaptador
        //reporteDiarioAdapter.clear();
        reporteDiarioAdapter.addAll(reporteDiarios);
        reporteDiarioAdapter.notifyItemRangeChanged(reporteDiarios.size(), 1);

        // Ocultar diálogo
        dialog.dismiss();
    }


    /*
    private void getNuevoReporteDiarioRutas(String ruta_id)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getNuevoReporteDiarioRutas");
            data.put("ruta", ruta_id);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            dialog.cancel();
                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            Log.d("DATA", data.toString());

                            reporteDiarioAdapter.clear();
                            reporteDiarios.clear();

                            btnGastos.setVisibility(View.VISIBLE);
                            btnTotales.setVisibility(View.VISIBLE);
                            btnGuardar.setVisibility(View.VISIBLE);

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);


                                Gson gson = new Gson();
                                ReporteDiario reporteDiario = gson.fromJson(obj.toString(), ReporteDiario.class);
                                reporteDiarios.add(reporteDiario);

                            }
                            reporteDiarioAdapter.addAll(reporteDiarios);
                            reporteDiarioAdapter.notifyItemRangeChanged(reporteDiarios.size(), 1);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                dialog.cancel();
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }
    */


    private void logUltimosTresRegistrosGastos() {
        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;

        try {
            // Consulta para obtener los últimos 3 registros
            String query = "SELECT * FROM gastos ORDER BY id DESC LIMIT 3";
            cursor = db.rawQuery(query, null);

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    // Obtener los datos de cada columna
                    int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String otros = cursor.getString(cursor.getColumnIndexOrThrow("otros"));
                    String gasolina = cursor.getString(cursor.getColumnIndexOrThrow("gasolina"));
                    String hotel = cursor.getString(cursor.getColumnIndexOrThrow("hotel"));
                    String alimentos = cursor.getString(cursor.getColumnIndexOrThrow("alimentos"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));

                    // Mostrar en el log
                    Log.d("UltimosRegistrosGastos", "ID: " + id +
                            ", otros ID: " + otros +
                            ", gasolina: " + gasolina +
                            ", hotel: " + hotel +
                            ", Status: " + status +
                            ", alimentos: " + alimentos);
                } while (cursor.moveToNext());
            } else {
                Log.d("UltimosRegistros", "No hay registros en la tabla gastos.");
            }

        } catch (Exception e) {
            Log.e("SQLiteError", "Error al obtener los últimos registros gastos: ", e);
        } finally {
            if (cursor != null) cursor.close();
            if (db != null) db.close();
        }
    }

    private void logUltimosTresRegistros() {
        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;

        try {
            // Consulta para obtener los últimos 3 registros
            String query = "SELECT * FROM reporte_diario_rutas ORDER BY id DESC LIMIT 3";
            cursor = db.rawQuery(query, null);

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    // Obtener los datos de cada columna
                    int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                    String estimacion = cursor.getString(cursor.getColumnIndexOrThrow("estimacion"));
                    String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                    String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    String gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));

                    // Mostrar en el log
                    Log.d("UltimosRegistros", "ID: " + id +
                            ", Poblacion ID: " + poblacion_id +
                            ", Estimación: " + estimacion +
                            ", Empleado_id: " + empleado_id +
                            ", Status: " + status +
                            ", gastos_id: " + gastos_id +
                            ", Fecha: " + fecha);
                } while (cursor.moveToNext());
            } else {
                Log.d("UltimosRegistros", "No hay registros en la tabla reporte_diario_rutas.");
            }

        } catch (Exception e) {
            Log.e("SQLiteError", "Error al obtener los últimos registros: ", e);
        } finally {
            if (cursor != null) cursor.close();
            if (db != null) db.close();
        }
    }
    private void getReporteDiarioRutas(String ruta_id, String fecha, String empleado_id) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        logUltimosTresRegistros();
        //logUltimosTresRegistrosGastos();

        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;

        try {
            // Construir la consulta dinámica
            String whereClause = "";
            String[] whereArgs = new String[]{};

            if (ruta_id != null && !ruta_id.isEmpty()) {
                whereClause += "clientes.ruta_id = ? ";
                whereArgs = appendToArray(whereArgs, ruta_id);
            }

            if (empleado_id != null && !empleado_id.isEmpty()) {
                if (!whereClause.isEmpty()) whereClause += "AND ";
                whereClause += "rd.empleado_id = ? ";
                whereArgs = appendToArray(whereArgs, empleado_id);
            }

            if (fecha != null && !fecha.isEmpty()) {
                if (!whereClause.isEmpty()) whereClause += "AND ";
                whereClause += "rd.fecha = ? ";
                whereArgs = appendToArray(whereArgs, fecha);
            }

            String query = "SELECT T1.poblacion_id, T1.ruta_id, T1.nombre_poblacion, " +
                    "T1.modalidad_semanas, SUM(T1.cantidad_esperada_pago) AS estimado, " +
                    "rd.estimacion, rd.abonos_semana, rd.recuperacion_semana, rd.anticipos, rd.total_1, " +
                    "rd.id, rd.recuperacion_prestamos, rd.colocacion, rd.prestamo_colocadora, " +
                    "rd.comision, rd.bono_colocadora, rd.total_2, rd.saldo, rd.pendiente_recuperar, " +
                    "rd.abonos_recuperar, rd.comentario, rd.empleado_id, rd.gastos_id, rd.fecha, rd.fecha_registro " +
                    "FROM ( " +
                    "SELECT pagos.cantidad_esperada_pago, pagos.semana, " +
                    "MAX(CASE WHEN pagos.fecha_pago >= date('now') AND pagos.fecha_pago < date('now', '+7 day') THEN pagos.fecha_pago END) AS fecha, " +
                    "clientes.nombre_completo, clientes.poblacion_id, clientes.ruta_id, prestamos.grupo_poblacion, " +
                    "prestamos.modalidad_semanas, poblaciones.nombre_poblacion, rutas.nombre_ruta, pagos.fecha_pago " +
                    "FROM pagos " +
                    "INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                    "INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                    "INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                    (ruta_id != null && !ruta_id.isEmpty() ? "WHERE clientes.ruta_id = ? " : "") + // Movido aquí
                    "GROUP BY prestamos.id " +
                    "ORDER BY clientes.poblacion_id DESC) AS T1 " +
                    "INNER JOIN reporte_diario_rutas AS rd ON rd.poblacion_id = T1.poblacion_id " +
                    "WHERE " +
                    (empleado_id != null && !empleado_id.isEmpty() ? "rd.empleado_id = ? AND " : "") +
                    (fecha != null && !fecha.isEmpty() ? "rd.fecha = ? " : "") +
                    "GROUP BY T1.nombre_poblacion " +
                    "ORDER BY T1.poblacion_id DESC";

            cursor = db.rawQuery(query, whereArgs);

            // Limpiar el adaptador de la lista de reportes
            reporteDiarios.clear();

            // Iniciar el objeto gastos
            Gastos gastos = new Gastos();
            boolean hayDatos = false;

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    ReporteDiario reporteDiario = new ReporteDiario();

                    // Mapear los campos seleccionados en el query
                    reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));
                    reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion")));
                    reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                    reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                    reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                    reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                    reporteDiario.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                    reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                    reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                    reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                    reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                    reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                    reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                    reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                    reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                    reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                    reporteDiario.setComentario(cursor.getString(cursor.getColumnIndexOrThrow("comentario")));
                    reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                    reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                    reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                    reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));
                    gastos_id = cursor.getString(cursor.getColumnIndexOrThrow("gastos_id"));
                    // Agregar a la lista de reportes
                    reporteDiarios.add(reporteDiario);
                    hayDatos = true;

                } while (cursor.moveToNext());
            }

            if (hayDatos) {
                // Mostrar los botones
                btnAgregar.setVisibility(View.VISIBLE);
                btnGastos.setVisibility(View.VISIBLE);
                btnTotales.setVisibility(View.VISIBLE);
                btnGuardar.setVisibility(View.VISIBLE);
            } else {
                // Si no hay datos, ocultamos los botones
                gastos_id = "";
                btnAgregar.setVisibility(View.GONE);
                btnGastos.setVisibility(View.GONE);
                btnTotales.setVisibility(View.GONE);
                btnGuardar.setVisibility(View.GONE);
                Toast.makeText(getActivity(), "No existe ningún reporte con los filtros ingresados", Toast.LENGTH_SHORT).show();
            }

            // Verificar si hay un gastos_id para realizar la operación
            if (!gastos_id.equals("")) {
                Log.d("ReporteDiarioFragment", "Dato en getReporteDiarioRutas(). ID GASTOS: " + gastos_id);
                getGastos(gastos_id);
            }

            // Actualizar el adaptador con los datos obtenidos
            reporteDiarioAdapter.addAll(reporteDiarios);
            reporteDiarioAdapter.notifyItemRangeChanged(reporteDiarios.size(), 1);

        } catch (Exception e) {
            Log.e("SQLiteError", "Error en la consulta local: ", e);
        } finally {
            if (cursor != null) cursor.close();
            if (db != null) db.close();
            dialog.dismiss();
        }
    }



    // Método auxiliar para agregar elementos a un arreglo
    private String[] appendToArray(String[] array, String element) {
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = element;
        return newArray;
    }


/*
    private void getReporteDiarioRutas(String ruta_id, String fecha, String empleado_id)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteDiarioRutas");
            data.put("ruta", ruta_id);
            data.put("fecha", fecha);
            data.put("empleado", empleado_id);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            dialog.cancel();
                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            Log.d("DATA", data.toString());

                            reporteDiarioAdapter.clear();
                            reporteDiarios.clear();

                            gastos = new Gastos();

                            if(data.length() > 0){

                                btnAgregar.setVisibility(View.VISIBLE);
                                btnGastos.setVisibility(View.VISIBLE);
                                btnTotales.setVisibility(View.VISIBLE);
                                btnGuardar.setVisibility(View.VISIBLE);

                                for(int i = 0; i < data.length(); i++){

                                    JSONObject obj = data.getJSONObject(i);

                                    gastos_id = obj.getString("gastos_id");

                                    Gson gson = new Gson();
                                    ReporteDiario reporteDiario = gson.fromJson(obj.toString(), ReporteDiario.class);
                                    reporteDiarios.add(reporteDiario);

                                }
                            }
                            else{
                                gastos_id = "";
                                btnAgregar.setVisibility(View.GONE);
                                btnGastos.setVisibility(View.GONE);
                                btnTotales.setVisibility(View.GONE);
                                btnGuardar.setVisibility(View.GONE);
                                Toast.makeText(getActivity(), "No existe ningun reporte con los filtros ingresados", Toast.LENGTH_SHORT).show();
                            }

                            if(!gastos_id.equals("")){
                                getGastos(gastos_id);
                            }

                            reporteDiarioAdapter.addAll(reporteDiarios);
                            reporteDiarioAdapter.notifyItemRangeChanged(reporteDiarios.size(), 1);


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                        // Toast.makeText(this, "nada", Toast.LENGTH_LONG).show();
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                dialog.cancel();
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
*/

    private void registrarGastos(Gastos gastos){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "createGastos");
            data.put("otros", gastos.getOtros());
            data.put("gasolina", gastos.getGasolina());
            data.put("hotel", gastos.getHotel());
            data.put("alimentos", gastos.getAlimentos());
            data.put("casetas", gastos.getCasetas());
            data.put("total", gastos.getTotal());

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String id = response.getJSONObject("data").getString("id");
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de id'....................: " + id);

                                registrarGastoEnSQLite(gastos.getOtros(), gastos.getGasolina(),gastos.getHotel(), gastos.getAlimentos(),
                                        gastos.getCasetas(), gastos.getTotal(),  id, "on");

                                for (ReporteDiario rd : reporteDiarioAdapter.reportesSeleccionados) {
                                    rd.setSeleccionado(false);
                                    registrarReporte(rd);
                                }

                                reporteDiarioAdapter.reportesSeleccionados.clear();

                                getNuevoReporteDiarioRutas(null);
                                tlFecha.getEditText().setText("");
                                rutasAutoCompleteTextView.setText("");

                                Toast.makeText(getActivity(), "Se registro el reporte", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                Toast.makeText(getActivity(), "Sin Conexión, Se registro el reporte en local", Toast.LENGTH_LONG).show();
                registrarGastoEnSQLite(gastos.getOtros(), gastos.getGasolina(),gastos.getHotel(), gastos.getAlimentos(),
                        gastos.getCasetas(), gastos.getTotal(), "", "off");

                for (ReporteDiario rd : reporteDiarioAdapter.reportesSeleccionados) {
                    rd.setSeleccionado(false);
                    registrarReporte(rd);
                }

                reporteDiarioAdapter.reportesSeleccionados.clear();

                getNuevoReporteDiarioRutas(null);
                tlFecha.getEditText().setText("");
                rutasAutoCompleteTextView.setText("");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void actualizarGastoEnSQLite(String id, String otros, String gasolina, String hotel, String alimentos, String casetas,
                                         String total, String online) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Crear el ContentValues con los valores que vamos a actualizar
        ContentValues valores = new ContentValues();
        valores.put("otros", otros);
        valores.put("gasolina", gasolina);
        valores.put("hotel", hotel);
        valores.put("alimentos", alimentos);
        valores.put("casetas", casetas);
        valores.put("total", total);

        // Definir el valor de status dependiendo del valor de "online"
        if (online.equals("off")) {
            valores.put("status", "2"); // Se pone el valor '2' cuando está 'off'
        } else {
            valores.put("status", "0"); // Se pone el valor '0' en otros casos
        }

        // Realizar la actualización en la base de datos con el idServer como criterio de búsqueda
        int resultado = db.update("gastos", valores, "id = ?", new String[]{id});

        if (resultado > 0) {
            Log.d("SQLite", "Gasto actualizado con éxito en SQLite con ID: " + id);
            //gasto_id = id;  // Asignar el ID actualizado
        } else {
            Log.d("SQLite", "Error al actualizar el gasto en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }


    private void registrarGastoEnSQLite(String otros, String gasolina, String hotel, String alimentos, String casetas,
                                        String total, String idServer, String online) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        String idGasto="";
        if(idServer!="")
        {
            idGasto = idServer;
        }
        else
        {
            idGasto = String.valueOf(obtenerSiguienteIdGasto(db));
        }
        // Crear el ContentValues para insertar el cliente
        ContentValues valores = new ContentValues();
        valores.put("id", idGasto); // Asignamos el nuevo ID
        valores.put("otros", otros);
        valores.put("gasolina", gasolina);
        valores.put("hotel", hotel);
        valores.put("alimentos", alimentos);
        valores.put("casetas", casetas);
        valores.put("total", total);
        if (online!="off")
        {
            valores.put("status", "0");
        }
        else
        {
            valores.put("status", "1");
        }

        // Insertar el nuevo gasto en la base de datos
        long resultado = db.insert("gastos", null, valores);

        if (resultado != -1) {
            Log.d("SQLite", "Gasto registrado con éxito en SQLite con ID: " + idGasto);
            gasto_id=idGasto;
        } else {
            Log.d("SQLite", "Error al registrar el gasto en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdGasto(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM gastos", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    private void editarGastos(Gastos gastos){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "editGastos");
            data.put("id", gastos.getId());
            data.put("otros", gastos.getOtros());
            data.put("gasolina", gastos.getGasolina());
            data.put("hotel", gastos.getHotel());
            data.put("alimentos", gastos.getAlimentos());
            data.put("casetas", gastos.getCasetas());
            data.put("total", gastos.getTotal());

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        actualizarGastoEnSQLite(gastos.getId(), gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(),
                                gastos.getTotal(), "on");
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                actualizarGastoEnSQLite(gastos.getId(), gastos.getOtros(), gastos.getGasolina(), gastos.getHotel(), gastos.getAlimentos(), gastos.getCasetas(),
                        gastos.getTotal(), "off");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }


    private void agregarComentario(String comentario, String fecha, String empleado_id){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "agregarComentarioReporteDiarioRutas");
            data.put("comentario", comentario);
            data.put("empleado_id", empleado_id);
            data.put("fecha", fecha);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d("PRESTSMOS", "Parametros enviados al servidor para agregarComentario: " + data.toString());
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        actualizarComentarioEnSQLite(comentario, empleado_id, fecha, "on");
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                actualizarComentarioEnSQLite(comentario, empleado_id, fecha, "off");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }
    private void actualizarComentarioEnSQLite(String comentario, String empleado_id, String fecha, String online) {
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        Log.d("SQLite", "ENTRO EN ACTUALIZAR COMENTARIO");
        Log.d("SQLite", "Datos recibidos -> Comentario: " + comentario + ", Fecha: " + fecha + ", Empleado ID: " + empleado_id + ", Online: " + online);
        // Verificar que los datos necesarios no estén vacíos
        if (fecha == null || fecha.isEmpty() || empleado_id == null || empleado_id.isEmpty()) {
            Log.d("SQLite", "Fecha o empleado_id no proporcionados para la actualización.");
            db.close();
            return;
        }

        // Crear el ContentValues con los valores que vamos a actualizar
        ContentValues valores = new ContentValues();
        valores.put("comentario", comentario);
        if (online!="off")
        {
            valores.put("status", "0");
        }
        else
        {
            valores.put("status", "2");
        }
        // Realizar la actualización en la base de datos con fecha y empleado_id como criterios
        int resultado = db.update("reporte_diario_rutas", valores, "empleado_id = ? AND fecha = ?", new String[]{empleado_id, fecha});

        if (resultado > 0) {
            Log.d("SQLite", "Comentario actualizado con éxito en SQLite para empleado_id: " + empleado_id + ", fecha: " + fecha);
        } else {
            Log.d("SQLite", "Comentario actualizado con éxito en SQLite para empleado_id: Error!!!! ");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }


    private void getGastos(String id) {
        Log.d("ReporteDiarioFragment", "ID GASTOS en getGastos.............: " + id);
        // Crear una instancia de la base de datos local
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Consulta SQL para obtener los gastos por ID
        String query = "SELECT * FROM gastos WHERE id = ?";
        Cursor cursor = null;

        try {
            // Ejecutar la consulta y obtener el cursor
            cursor = db.rawQuery(query, new String[]{id});

            // Verificar si se encontraron datos
            if (cursor != null && cursor.moveToFirst()) {
                // Crear un objeto Gastos para mapear los resultados
                gastos = new Gastos();

                // Mapear los campos del cursor a los atributos de la clase Gastos
                gastos.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                gastos.setOtros(cursor.getString(cursor.getColumnIndexOrThrow("otros")));
                gastos.setGasolina(cursor.getString(cursor.getColumnIndexOrThrow("gasolina")));
                gastos.setHotel(cursor.getString(cursor.getColumnIndexOrThrow("hotel")));
                gastos.setAlimentos(cursor.getString(cursor.getColumnIndexOrThrow("alimentos")));
                gastos.setCasetas(cursor.getString(cursor.getColumnIndexOrThrow("casetas")));
                gastos.setTotal(cursor.getString(cursor.getColumnIndexOrThrow("total")));

                // Aquí puedes agregar cualquier otro campo que estés almacenando en la tabla gastos
                Log.d("GASTOS LOCAL", "GASTOS TRAIDOS DE LA CONSULTA en getGastos.............: " + gastos.toString());

                // Si deseas realizar alguna acción con los datos, puedes hacerlo aquí
                // Por ejemplo, mostrar un mensaje o actualizar la UI
            } else {
                // Si no se encuentra el gasto con ese ID, puedes mostrar un mensaje o tomar otra acción
                Toast.makeText(getActivity(), "No se encontraron gastos con el ID " + id, Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(getActivity(), "Error al obtener los gastos", Toast.LENGTH_SHORT).show();
        } finally {
            // Cerrar el cursor y la base de datos
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    /*
    private void getGastos(String id)
    {

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getGastos");
            data.put("id", id);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            JSONObject obj = data.getJSONObject(0);

                            Gson gson = new Gson();
                            gastos = gson.fromJson(obj.toString(), Gastos.class);

                            Log.d("DATA GASTOS", data.toString());

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                        // Toast.makeText(this, "nada", Toast.LENGTH_LONG).show();
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    */
    private void registrarReporte(ReporteDiario reporteDiario){
        Log.d("SEND", "ENTRO A REGISTRAR REPORTE.................");
        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "createReporteDiarioRutas");
            data.put("poblacion_id", reporteDiario.getPoblacion_id());
            data.put("estimacion", (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion(): reporteDiario.getEstimado()));
            data.put("abonos_semana", reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", reporteDiario.getRecuperacion_semana());
            data.put("anticipos", reporteDiario.getAnticipos());
            data.put("total_1", reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", reporteDiario.getColocacion());
            data.put("prestamo_colocadora", reporteDiario.getPrestamo_colocadora());
            data.put("comision", reporteDiario.getComision());
            data.put("bono_colocadora", reporteDiario.getBono_colocadora());
            data.put("total_2", reporteDiario.getTotal_2());
            data.put("saldo", reporteDiario.getSaldo());
            data.put("pendiente_recuperar", reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", reporteDiario.getAbonos_recuperar());
            data.put("comentario", reporteDiario.getComentario());
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("fecha", tlFecha.getEditText().getText().toString());


        } catch (JSONException e) {
            e.printStackTrace();
        }
        String fecha = tlFecha.getEditText().getText().toString();
        Log.d("SEND", data.toString());
        Log.d("SEND", "FECHA INSERTADA EN SQLITE:....................." + fecha);
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String id = response.getJSONObject("data").getString("id");
                                String gastosId = response.getJSONObject("data").getString("gastos_id");

                                Log.d("DEBUG", "Respuesta JSON contiene EN LINEA 'data de id'....................: " + id);
                                Log.d("DEBUG", "Respuesta JSON contiene EN LINEA 'data de gastosId'....................: " + gastosId);

                                registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado()),
                                        reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(),
                                        reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(),
                                        reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                                        reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(),
                                        reporteDiario.getComentario(), sesion.getString("id", "0"), fecha, gastosId, id, "on");
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion() : reporteDiario.getEstimado()),
                        reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(),
                        reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(),
                        reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                        reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(),
                        reporteDiario.getComentario(), sesion.getString("id", "0"), fecha, gasto_id, "", "off");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void agregarRegistroReporte(ReporteDiario reporteDiario){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "agregarRegistroReporteDiarioRutas");
            data.put("poblacion_id", reporteDiario.getPoblacion_id());
            data.put("estimacion", (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion(): reporteDiario.getEstimado()));
            data.put("abonos_semana", reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", reporteDiario.getRecuperacion_semana());
            data.put("anticipos", reporteDiario.getAnticipos());
            data.put("total_1", reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", reporteDiario.getColocacion());
            data.put("prestamo_colocadora", reporteDiario.getPrestamo_colocadora());
            data.put("comision", reporteDiario.getComision());
            data.put("bono_colocadora", reporteDiario.getBono_colocadora());
            data.put("total_2", reporteDiario.getTotal_2());
            data.put("saldo", reporteDiario.getSaldo());
            data.put("pendiente_recuperar", reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", reporteDiario.getAbonos_recuperar());
            data.put("comentario", reporteDiario.getComentario());
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("fecha", tlFecha.getEditText().getText().toString());
            data.put("gastos_id", reporteDiario.getGastos_id());

        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("SEND", data.toString());

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String id = response.getJSONObject("data").getString("id");

                                registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion(): reporteDiario.getEstimado()),
                                        reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(),
                                        reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(),
                                        reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                                        reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(),
                                        reporteDiario.getComentario(), sesion.getString("id", "0"), tlFecha.getEditText().getText().toString(), reporteDiario.getGastos_id(), id, "on");
                                getReporteDiarioRutas(poblacion_id, tlFecha.getEditText().getText().toString(), sesion.getString("id", ""));
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                registrarReporteEnSQLite(reporteDiario.getPoblacion_id(), (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion(): reporteDiario.getEstimado()),
                        reporteDiario.getAbonos_semana(), reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(),
                        reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(), reporteDiario.getColocacion(),
                        reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                        reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(),
                        reporteDiario.getComentario(), sesion.getString("id", "0"), tlFecha.getEditText().getText().toString(), reporteDiario.getGastos_id(), "", "off");
                getReporteDiarioRutas(poblacion_id, tlFecha.getEditText().getText().toString(), sesion.getString("id", ""));
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    private int contador = 0;
    private void registrarReporteEnSQLite(String poblacion_id, String estimacion, String abonos_semana, String recuperacion_semana, String anticipos,
                                          String total_1, String recuperacion_prestamos, String colocacion, String prestamo_colocadora, String comision,
                                          String bono_colocadora, String total_2, String saldo, String pendiente_recuperar, String abonos_recuperar,
                                          String comentario, String empleado_id, String fecha, String gastos_id, String idServer, String online) {
        contador++;

        // Imprimir el valor del contador en el Log
        Log.d("SQLite", "Se ha llamado a registrarReporteCreditosEnSQLite " + contador + " veces.");
        Log.d("SEND", "ENTRO A REGISTRAR REPORTE EN SQLITE.................");
        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        String idReporte = (idServer != null && !idServer.isEmpty()) ? idServer : String.valueOf(obtenerSiguienteIdReporte(db));
        // Crear el ContentValues para insertar el cliente
        ContentValues valores = new ContentValues();
        valores.put("id", idReporte); // Asignamos el nuevo ID
        valores.put("poblacion_id", poblacion_id);
        valores.put("estimacion", estimacion);
        valores.put("abonos_semana", abonos_semana);
        valores.put("recuperacion_semana", recuperacion_semana);
        valores.put("anticipos", anticipos);
        valores.put("total_1", total_1);
        valores.put("recuperacion_prestamos", recuperacion_prestamos);
        valores.put("colocacion", colocacion);
        valores.put("prestamo_colocadora", prestamo_colocadora);
        valores.put("comision", comision);
        valores.put("bono_colocadora", bono_colocadora);
        valores.put("total_2", total_2);
        valores.put("saldo", saldo);
        valores.put("pendiente_recuperar", pendiente_recuperar);
        valores.put("abonos_recuperar", abonos_recuperar);
        valores.put("comentario", comentario);
        valores.put("empleado_id", empleado_id);
        valores.put("fecha", fecha);
        valores.put("gastos_id", gastos_id);

        if(online!="off")
        {
            valores.put("status", "0");
        }
        else
        {
            valores.put("status", "1");
        }

        Calendar calendar = Calendar.getInstance();

        // Restar 10 minutos
        calendar.add(Calendar.MINUTE, -10);

        // Obtener la nueva fecha después de restar los 10 minutos
        Date nuevaFecha = calendar.getTime();

        // Formatear la fecha en el formato que necesitas (yyyy-MM-dd HH:mm:ss)
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String fechaRestada = dateFormat.format(nuevaFecha);

        valores.put("fecha_registro", fechaRestada);

        Log.d("SQLite", "fecha al registrar el reporte en SQLite." + fecha);


        // Insertar el nuevo cliente en la base de datos
        long resultado = db.insert("reporte_diario_rutas", null, valores);

        if (resultado != -1) {
            Log.d("SQLite", "reporte registrado con éxito en SQLite con ID: " + idReporte);
        } else {
            Log.d("SQLite", "Error al registrar el reporte en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }

    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdReporte(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM reporte_diario_rutas", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    private void editarRegistroReporte(ReporteDiario reporteDiario){

        Log.d("SQLite", "ENTRO EN EDITAR REPORTE PARA COMENTARIO: ");

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "editReporteDiarioRutas");
            data.put("id", reporteDiario.getId());
            data.put("estimacion", (reporteDiario.getEstimacion() != null ? reporteDiario.getEstimacion(): reporteDiario.getEstimado()));
            data.put("abonos_semana", reporteDiario.getAbonos_semana());
            data.put("recuperacion_semana", reporteDiario.getRecuperacion_semana());
            data.put("anticipos", reporteDiario.getAnticipos());
            data.put("total_1", reporteDiario.getTotal_1());
            data.put("recuperacion_prestamos", reporteDiario.getRecuperacion_prestamos());
            data.put("colocacion", reporteDiario.getColocacion());
            data.put("prestamo_colocadora", reporteDiario.getPrestamo_colocadora());
            data.put("comision", reporteDiario.getComision());
            data.put("bono_colocadora", reporteDiario.getBono_colocadora());
            data.put("total_2", reporteDiario.getTotal_2());
            data.put("saldo", reporteDiario.getSaldo());
            data.put("pendiente_recuperar", reporteDiario.getPendiente_recuperar());
            data.put("abonos_recuperar", reporteDiario.getAbonos_recuperar());

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            String message = (String) response.get("message");
                            actualizarReporteEnSQLite(reporteDiario.getId(), reporteDiario.getEstimacion(), reporteDiario.getAbonos_semana(),
                                    reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(),
                                    reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                                    reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), "on"
                            );

                            getReporteDiarioRutas(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                actualizarReporteEnSQLite(reporteDiario.getId(), reporteDiario.getEstimacion(), reporteDiario.getAbonos_semana(),
                        reporteDiario.getRecuperacion_semana(), reporteDiario.getAnticipos(), reporteDiario.getTotal_1(), reporteDiario.getRecuperacion_prestamos(),
                        reporteDiario.getColocacion(), reporteDiario.getPrestamo_colocadora(), reporteDiario.getComision(), reporteDiario.getBono_colocadora(),
                        reporteDiario.getTotal_2(), reporteDiario.getSaldo(), reporteDiario.getPendiente_recuperar(), reporteDiario.getAbonos_recuperar(), "off"
                );
                getReporteDiarioRutas(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void actualizarReporteEnSQLite(String id, String estimacion, String abonosSemana, String recuperacionSemana, String anticipos, String total1,
                                           String recuperacionPrestamos, String colocacion, String prestamoColocadora, String comision, String bonoColocadora,
                                           String total2, String saldo, String pendienteRecuperar, String abonosRecuperar, String online) {
        // Crear o abrir la base de datos
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        try {
            // Crear un objeto ContentValues con los valores a actualizar
            ContentValues valores = new ContentValues();
            valores.put("estimacion", estimacion);
            valores.put("abonos_semana", abonosSemana);
            valores.put("recuperacion_semana", recuperacionSemana);
            valores.put("anticipos", anticipos);
            valores.put("total_1", total1);
            valores.put("recuperacion_prestamos", recuperacionPrestamos);
            valores.put("colocacion", colocacion);
            valores.put("prestamo_colocadora", prestamoColocadora);
            valores.put("comision", comision);
            valores.put("bono_colocadora", bonoColocadora);
            valores.put("total_2", total2);
            valores.put("saldo", saldo);
            valores.put("pendiente_recuperar", pendienteRecuperar);
            valores.put("abonos_recuperar", abonosRecuperar);

            long timestamp = System.currentTimeMillis();

            if(online!="off")
            {
                valores.put("status", "0");
                timestamp -= 10000; // - 10 segundos = 10,000 milisegundos
            }
            else
            {
                valores.put("status", "2");
                timestamp += 10000; // + 10 segundos = 10,000 milisegundos
            }

            // Formatear la nueva hora
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));

            valores.put("fecha_registro", formattedDate);

            // Actualizar el registro en la base de datos
            int filasActualizadas = db.update(
                    "reporte_diario_rutas",           // Nombre de la tabla
                    valores,                          // Nuevos valores
                    "id = ?",                         // Clausula WHERE
                    new String[]{id} // Argumento para WHERE
            );

            // Verificar si la actualización fue exitosa
            if (filasActualizadas > 0) {
                Log.d("SQLite", "Reporte actualizado con éxito en SQLite con ID: " + id);
            } else {
                Log.d("SQLite", "No se encontró el reporte con ID: " + id + " para actualizar.");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.d("SQLite", "Error al actualizar el reporte en SQLite: " + e.getMessage());
        } finally {
            db.close(); // Cerrar la conexión a la base de datos
        }
    }


    private void filtrarReporte(String ruta_id){

        reporteDiariosFiltrado = new ArrayList<>();
        reporteDiariosFiltrado.clear();

        for(ReporteDiario rd: reporteDiarios){

            if(rd.getRuta_id().equals(ruta_id)){
                reporteDiariosFiltrado.add(rd);
            }

        }

        if(!reporteDiariosFiltrado.isEmpty()){
            reporteDiarioAdapter.setListaFiltrada(reporteDiariosFiltrado);
        }

    }

    private void filtrarReportePoblaciones(String text){

        if(reporteDiariosFiltrado.size() == 0){


            for(ReporteDiario rd: reporteDiarios){
                if(rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())){
                    reporteDiariosFiltrado.add(rd);
                }
            }

            if(!reporteDiariosFiltrado.isEmpty()){
                reporteDiarioAdapter.setListaFiltrada(reporteDiariosFiltrado);
            }

        }
        else{

            reportesFiltradosNombres = new ArrayList<>();

            for(ReporteDiario rd: reporteDiariosFiltrado){
                if(rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())){
                    reportesFiltradosNombres.add(rd);
                }
            }

            if(!reportesFiltradosNombres.isEmpty()){
                reporteDiarioAdapter.setListaFiltrada(reportesFiltradosNombres);
            }
        }

    }

    private void getPoblaciones(String ruta_id, AutoCompleteTextView poblacionesAT) {
        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getNuevoReporteDiarioRutas");
            data.put("ruta", ruta_id);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        Log.d("SEND", data.toString());

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

//                          poblacionesAdapter.clear();
                            poblacionesReporte.clear();

                            btnGastos.setVisibility(View.VISIBLE);
                            btnTotales.setVisibility(View.VISIBLE);
                            btnGuardar.setVisibility(View.VISIBLE);

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);

                                Log.d("DATA", obj.toString());
                                Gson gson = new Gson();
                                ReporteDiario reporteDiario = gson.fromJson(obj.toString(), ReporteDiario.class);
                                poblacionesReporte.add(reporteDiario);

                            }
                            poblacionesAdapter = new ArrayAdapter<ReporteDiario>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesReporte);

                            poblacionesAT.setThreshold(1);
                            poblacionesAT.setAdapter(poblacionesAdapter);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                        // Toast.makeText(this, "nada", Toast.LENGTH_LONG).show();
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                Log.e("API_ERROR", "Error en la respuesta de la API: ", error);

                // Aquí realizamos la consulta local a SQLite
                DatabaseHelper dbHelper = new DatabaseHelper(getContext());
                SQLiteDatabase db = dbHelper.getWritableDatabase(); // Asegúrate de tener una instancia de tu DbHelper
                Cursor cursor = null;

                String query = "SELECT " +
                        "TABLA_ESTIMADOS.poblacion_id, " +
                        "TABLA_ESTIMADOS.ruta_id, " +
                        "TABLA_ESTIMADOS.nombre_poblacion, " +
                        "TABLA_ESTIMADOS.modalidad_semanas, " +
                        "SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, " +
                        "'' AS estimacion, '' AS abonos_semana, '' AS recuperacion_semana, " +
                        "'' AS anticipos, '' AS total_1, '' AS recuperacion_prestamos, '' AS colocacion, " +
                        "'' AS prestamo_colocadora, '' AS comision, '' AS bono_colocadora, '' AS total_2, " +
                        "'' AS saldo, '' AS pendiente_recuperar, '' AS abonos_recuperar, " +
                        "'' AS empleado_id, '' AS gastos_id, '' AS fecha, '' AS fecha_registro " +
                        "FROM ( " +
                        "    SELECT " +
                        "        pagos.cantidad_esperada_pago, " +
                        "        pagos.semana, " +
                        "        poblaciones.primer_dia_cobro, " +
                        "        MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago, " +
                        "        clientes.nombre_completo, " +
                        "        clientes.poblacion_id, " +
                        "        clientes.ruta_id, " +
                        "        prestamos.grupo_poblacion, " +
                        "        prestamos.modalidad_semanas, " +
                        "        poblaciones.nombre_poblacion, " +
                        "        rutas.nombre_ruta, " +
                        "        prestamos.status, " +
                        "        prestamos.updated_at " +
                        "    FROM pagos " +
                        "    INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                        "    INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                        "    INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                        "    INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                        "    WHERE ( " +
                        "        (prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') AND prestamos.status IN (0, 2)) " +
                        "        OR (prestamos.status = 0) " +
                        "    ) " +
                        (ruta_id != null ? "AND clientes.ruta_id = ? " : "") +
                        "    GROUP BY prestamos.id " +
                        ") AS TABLA_ESTIMADOS " +
                        "GROUP BY TABLA_ESTIMADOS.nombre_poblacion " +
                        "ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";


                try {
                    if (ruta_id != null) {
                        cursor = db.rawQuery(query, new String[]{ruta_id});
                    } else {
                        cursor = db.rawQuery(query, null);
                    }

                    if (cursor.moveToFirst()) {
                        do {

                            for (int i = 0; i < cursor.getColumnCount(); i++) {
                                String columnName = cursor.getColumnName(i);
                                String value = cursor.getString(i);
                                Log.d("SQLiteResult", "Columna: " + columnName + " = " + value);
                            }

                            ReporteDiario reporteDiario = new ReporteDiario();

                            // Campos que aparecen en la consulta
                            reporteDiario.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                            reporteDiario.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                            reporteDiario.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                            reporteDiario.setEstimado(cursor.getString(cursor.getColumnIndexOrThrow("estimado")));

                            // Campos adicionales según la consulta SQL
                            reporteDiario.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion"))); // Ejemplo, si está en el modelo
                            reporteDiario.setAbonos_semana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                            reporteDiario.setRecuperacion_semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                            reporteDiario.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                            reporteDiario.setTotal_1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                            reporteDiario.setRecuperacion_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                            reporteDiario.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                            reporteDiario.setPrestamo_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                            reporteDiario.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                            reporteDiario.setBono_colocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                            reporteDiario.setTotal_2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                            reporteDiario.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                            reporteDiario.setPendiente_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                            reporteDiario.setAbonos_recuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                            reporteDiario.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                            reporteDiario.setGastos_id(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                            reporteDiario.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                            reporteDiario.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));

                            // Agregar a la lista
                            poblacionesReporte.add(reporteDiario);

                        } while (cursor.moveToNext());
                    }

                    // Configurar adaptador con los datos locales
                    poblacionesAdapter = new ArrayAdapter<>(
                            getContext(),
                            android.R.layout.simple_dropdown_item_1line,
                            poblacionesReporte
                    );
                    poblacionesAT.setThreshold(1);
                    poblacionesAT.setAdapter(poblacionesAdapter);

                } catch (Exception e) {
                    Log.e("SQLiteError", "Error al ejecutar la consulta local", e);
                } finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    db.close();
                }
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }


}